<?php
session_start();
require_once "../config/db.php";

// 🔐 Admin login check
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

// Handle credit/debit actions
$message = "";
if(isset($_POST['update_wallet'])){
    $user_id = intval($_POST['user_id']);
    $action = $_POST['action']; // credit or debit
    $amount = floatval($_POST['amount']);

    // Fetch current balance
    $user = $conn->query("SELECT balance FROM users WHERE id=$user_id")->fetch_assoc();
    if(!$user){
        $message = "User not found!";
    } else {
        $current_balance = $user['balance'];
        if($action === "credit"){
            $new_balance = $current_balance + $amount;
        } elseif($action === "debit"){
            if($current_balance < $amount){
                $message = "Insufficient balance!";
                $new_balance = $current_balance;
            } else {
                $new_balance = $current_balance - $amount;
            }
        }
        if(empty($message)){
            // Update balance
            $stmt = $conn->prepare("UPDATE users SET balance=? WHERE id=?");
            $stmt->bind_param("di", $new_balance, $user_id);
            $stmt->execute();

            // Log transaction
            $stmt = $conn->prepare("INSERT INTO transactions (user_id, service, description, amount, status) VALUES (?,?,?,?,?)");
            $desc = strtoupper($action)." BY ADMIN";
            $status = "SUCCESS";
            $stmt->bind_param("issds", $user_id, $action."_WALLET", $desc, $amount, $status);
            $stmt->execute();

            $message = "Wallet updated successfully!";
        }
    }
}

// Fetch all users
$users = $conn->query("SELECT id, fullname, email, balance, referral_bonus FROM users ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>User Wallets | Admin | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;justify-content:space-between;}
header h2{margin:0;}
nav a{color:#fff;text-decoration:none;margin-left:15px;}
.container{padding:15px;}
table{width:100%;border-collapse:collapse;background:#fff;border-radius:10px;overflow:hidden;box-shadow:0 4px 8px rgba(0,0,0,.05);}
th,td{padding:12px;text-align:left;border-bottom:1px solid #eee;}
th{background:#203a43;color:#fff;}
tr:hover{background:#f4f6f8;}
form{display:flex;gap:5px;}
input[type=number]{width:80px;padding:5px;border-radius:5px;border:1px solid #ddd;}
select{padding:5px;border-radius:5px;border:1px solid #ddd;}
button{padding:5px 10px;border:none;background:#203a43;color:#fff;border-radius:5px;}
.msg{padding:10px;margin-bottom:10px;border-radius:8px;background:#e7f6ed;color:#1e7e34;}
</style>
</head>
<body>

<header>
    <h2>User Wallets</h2>
    <nav>
        <span><?php echo $_SESSION['admin_name'] ?? 'Admin'; ?></span>
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="auth.php?logout=1"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </nav>
</header>

<div class="container">

<?php if($message): ?>
<div class="msg"><?php echo $message; ?></div>
<?php endif; ?>

<h3>Manage User Wallets</h3>
<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>Full Name</th>
            <th>Email</th>
            <th>Wallet (₦)</th>
            <th>Referral Bonus (₦)</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
    <?php if($users->num_rows > 0): ?>
        <?php while($u = $users->fetch_assoc()): ?>
        <tr>
            <td><?php echo $u['id']; ?></td>
            <td><?php echo htmlspecialchars($u['fullname']); ?></td>
            <td><?php echo htmlspecialchars($u['email']); ?></td>
            <td><?php echo number_format($u['balance'],2); ?></td>
            <td><?php echo number_format($u['referral_bonus'],2); ?></td>
            <td>
                <form method="POST">
                    <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
                    <input type="number" name="amount" placeholder="Amount" required>
                    <select name="action">
                        <option value="credit">Credit</option>
                        <option value="debit">Debit</option>
                    </select>
                    <button type="submit" name="update_wallet"><i class="fas fa-check"></i></button>
                </form>
            </td>
        </tr>
        <?php endwhile; ?>
    <?php else: ?>
        <tr><td colspan="6" style="text-align:center;">No users found.</td></tr>
    <?php endif; ?>
    </tbody>
</table>

</div>
</body>
</html>