<?php
session_start();
require_once "../config/db.php";
require_once "functions.php";

// 🔐 Admin login check
if(!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}

// Handle user deletion
if(isset($_GET['delete'])) {
    $delete_id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM users WHERE id=?");
    $stmt->bind_param("i", $delete_id);
    $stmt->execute();
    header("Location: users.php");
    exit;
}

// Fetch all users
$users = $conn->query("SELECT id, fullname, email, phone, balance, referral_bonus, account_number FROM users ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Users | Admin | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;justify-content:space-between;}
header h2{margin:0;}
nav a{color:#fff;text-decoration:none;margin-left:15px;}
.container{padding:15px;}
table{width:100%;border-collapse:collapse;background:#fff;border-radius:10px;overflow:hidden;box-shadow:0 4px 8px rgba(0,0,0,.05);}
th,td{padding:12px;text-align:left;border-bottom:1px solid #eee;}
th{background:#203a43;color:#fff;}
tr:hover{background:#f4f6f8;}
.action a{margin-right:10px;color:#203a43;text-decoration:none;}
.action a.delete{color:#b71c1c;}
</style>
</head>
<body>

<header>
    <h2>Manage Users</h2>
    <nav>
        <span><?php echo $_SESSION['admin_name'] ?? 'Admin'; ?></span>
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="auth.php?logout=1"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </nav>
</header>

<div class="container">

<h3>All Users</h3>
<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>Full Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Account No</th>
            <th>Wallet (₦)</th>
            <th>Referral Bonus (₦)</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
    <?php if($users->num_rows > 0): ?>
        <?php while($user = $users->fetch_assoc()): ?>
        <tr>
            <td><?php echo $user['id']; ?></td>
            <td><?php echo htmlspecialchars($user['fullname']); ?></td>
            <td><?php echo htmlspecialchars($user['email']); ?></td>
            <td><?php echo htmlspecialchars($user['phone']); ?></td>
            <td><?php echo htmlspecialchars($user['account_number']); ?></td>
            <td><?php echo number_format($user['balance'],2); ?></td>
            <td><?php echo number_format($user['referral_bonus'],2); ?></td>
            <td class="action">
                <a href="view_user.php?id=<?php echo $user['id']; ?>"><i class="fas fa-eye"></i></a>
                <a href="edit_user.php?id=<?php echo $user['id']; ?>"><i class="fas fa-edit"></i></a>
                <a href="users.php?delete=<?php echo $user['id']; ?>" onclick="return confirm('Are you sure?');" class="delete"><i class="fas fa-trash"></i></a>
            </td>
        </tr>
        <?php endwhile; ?>
    <?php else: ?>
        <tr><td colspan="8" style="text-align:center;">No users found.</td></tr>
    <?php endif; ?>
    </tbody>
</table>

</div>
</body>
</html>