<?php
session_start();
require_once "../config/db.php";
require_once "functions.php";

// 🔐 Admin login check
if(!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}

// Optional filters
$filter_status = $_GET['status'] ?? '';
$filter_service = $_GET['service'] ?? '';
$where = [];

if($filter_status) $where[] = "status='".$conn->real_escape_string($filter_status)."'";
if($filter_service) $where[] = "service='".$conn->real_escape_string($filter_service)."'";

$where_sql = count($where) > 0 ? "WHERE ".implode(" AND ", $where) : "";

// Fetch transactions
$transactions = $conn->query("
    SELECT t.id, t.user_id, t.service, t.description, t.amount, t.status, t.created_at, u.fullname, u.email
    FROM transactions t
    JOIN users u ON t.user_id = u.id
    $where_sql
    ORDER BY t.created_at DESC
");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Transactions | Admin | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;justify-content:space-between;}
header h2{margin:0;}
nav a{color:#fff;text-decoration:none;margin-left:15px;}
.container{padding:15px;}
form{margin-bottom:15px;display:flex;gap:10px;flex-wrap:wrap;}
select, button{padding:10px;border-radius:8px;border:1px solid #ddd;}
table{width:100%;border-collapse:collapse;background:#fff;border-radius:10px;overflow:hidden;box-shadow:0 4px 8px rgba(0,0,0,.05);}
th,td{padding:12px;text-align:left;border-bottom:1px solid #eee;}
th{background:#203a43;color:#fff;}
tr:hover{background:#f4f6f8;}
.status-success{color:#1e7e34;font-weight:bold;}
.status-failed{color:#b71c1c;font-weight:bold;}
</style>
</head>
<body>

<header>
    <h2>Transactions</h2>
    <nav>
        <span><?php echo $_SESSION['admin_name'] ?? 'Admin'; ?></span>
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="auth.php?logout=1"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </nav>
</header>

<div class="container">

<h3>All Transactions</h3>

<form method="GET">
    <select name="status">
        <option value="">-- Filter by Status --</option>
        <option value="SUCCESS" <?php if($filter_status=="SUCCESS") echo "selected"; ?>>SUCCESS</option>
        <option value="FAILED" <?php if($filter_status=="FAILED") echo "selected"; ?>>FAILED</option>
    </select>

    <select name="service">
        <option value="">-- Filter by Service --</option>
        <option value="FUND_WALLET" <?php if($filter_service=="FUND_WALLET") echo "selected"; ?>>FUND_WALLET</option>
        <option value="AIRTIME" <?php if($filter_service=="AIRTIME") echo "selected"; ?>>AIRTIME</option>
        <option value="DATA_BUNDLE" <?php if($filter_service=="DATA_BUNDLE") echo "selected"; ?>>DATA_BUNDLE</option>
        <option value="TV" <?php if($filter_service=="TV") echo "selected"; ?>>TV</option>
        <option value="EXAM_PIN" <?php if($filter_service=="EXAM_PIN") echo "selected"; ?>>EXAM_PIN</option>
        <option value="ELECTRIC" <?php if($filter_service=="ELECTRIC") echo "selected"; ?>>ELECTRIC</option>
        <option value="RECHARGE_PIN" <?php if($filter_service=="RECHARGE_PIN") echo "selected"; ?>>RECHARGE_PIN</option>
        <option value="REFER" <?php if($filter_service=="REFER") echo "selected"; ?>>REFER</option>
    </select>

    <button type="submit"><i class="fas fa-filter"></i> Filter</button>
</form>

<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>User</th>
            <th>Email</th>
            <th>Service</th>
            <th>Description</th>
            <th>Amount (₦)</th>
            <th>Status</th>
            <th>Date</th>
        </tr>
    </thead>
    <tbody>
    <?php if($transactions->num_rows > 0): ?>
        <?php while($t = $transactions->fetch_assoc()): ?>
        <tr>
            <td><?php echo $t['id']; ?></td>
            <td><?php echo htmlspecialchars($t['fullname']); ?></td>
            <td><?php echo htmlspecialchars($t['email']); ?></td>
            <td><?php echo htmlspecialchars($t['service']); ?></td>
            <td><?php echo htmlspecialchars($t['description']); ?></td>
            <td><?php echo number_format($t['amount'],2); ?></td>
            <td class="status-<?php echo strtolower($t['status']); ?>"><?php echo $t['status']; ?></td>
            <td><?php echo date("d M Y, H:i", strtotime($t['created_at'])); ?></td>
        </tr>
        <?php endwhile; ?>
    <?php else: ?>
        <tr><td colspan="8" style="text-align:center;">No transactions found.</td></tr>
    <?php endif; ?>
    </tbody>
</table>

</div>
</body>
</html>