<?php
session_start();
require_once "../config/db.php";

// 🔐 Admin login check
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

// Handle form submission
$message = "";
if(isset($_POST['save_settings'])){
    $api_key = trim($_POST['api_key']);
    $api_url = trim($_POST['api_url']);
    $api_provider = trim($_POST['api_provider']);

    // Check if settings exist
    $result = $conn->query("SELECT id FROM api_settings LIMIT 1");
    if($result->num_rows > 0){
        $stmt = $conn->prepare("UPDATE api_settings SET api_key=?, api_url=?, api_provider=? WHERE id=1");
        $stmt->bind_param("sss", $api_key, $api_url, $api_provider);
        $stmt->execute();
    } else {
        $stmt = $conn->prepare("INSERT INTO api_settings (api_key, api_url, api_provider) VALUES (?,?,?)");
        $stmt->bind_param("sss", $api_key, $api_url, $api_provider);
        $stmt->execute();
    }

    $message = "API settings saved successfully!";
}

// Fetch existing settings
$settings = $conn->query("SELECT * FROM api_settings LIMIT 1")->fetch_assoc() ?? ['api_key'=>'','api_url'=>'','api_provider'=>''];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>API Settings | Admin | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;justify-content:space-between;}
header h2{margin:0;}
nav a{color:#fff;text-decoration:none;margin-left:15px;}
.container{padding:15px;}
.card{background:#fff;padding:20px;border-radius:15px;box-shadow:0 4px 8px rgba(0,0,0,.05);}
label{display:block;margin-top:10px;color:#333;font-weight:bold;}
input{width:100%;padding:12px;margin-top:5px;border-radius:8px;border:1px solid #ddd;}
button{margin-top:15px;padding:12px;background:#203a43;color:#fff;border:none;border-radius:10px;font-size:15px;}
.msg{padding:10px;margin-bottom:10px;border-radius:8px;background:#e7f6ed;color:#1e7e34;}
</style>
</head>
<body>

<header>
    <h2>API Settings</h2>
    <nav>
        <span><?php echo $_SESSION['admin_name'] ?? 'Admin'; ?></span>
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="auth.php?logout=1"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </nav>
</header>

<div class="container">
<div class="card">
<?php if($message): ?>
<div class="msg"><?php echo $message; ?></div>
<?php endif; ?>

<form method="POST">
    <label>API Provider</label>
    <input type="text" name="api_provider" value="<?php echo htmlspecialchars($settings['api_provider']); ?>" required>

    <label>API Key</label>
    <input type="text" name="api_key" value="<?php echo htmlspecialchars($settings['api_key']); ?>" required>

    <label>API URL / Endpoint</label>
    <input type="text" name="api_url" value="<?php echo htmlspecialchars($settings['api_url']); ?>" required>

    <button type="submit" name="save_settings"><i class="fas fa-save"></i> Save Settings</button>
</form>
</div>
</div>

</body>
</html>