<?php
session_start();
require_once "../config/db.php";
require_once "functions.php";

// 🔐 Admin login check
if(!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}

// Fetch stats
$total_users = $conn->query("SELECT COUNT(*) AS count FROM users")->fetch_assoc()['count'];
$total_transactions = $conn->query("SELECT COUNT(*) AS count FROM transactions")->fetch_assoc()['count'];
$total_wallet = $conn->query("SELECT SUM(balance) AS total FROM users")->fetch_assoc()['total'];
$total_referral_bonus = $conn->query("SELECT SUM(referral_bonus) AS total FROM users")->fetch_assoc()['total'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Dashboard | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;justify-content:space-between;}
header h2{margin:0;}
nav a{color:#fff;text-decoration:none;margin-left:15px;}
.container{padding:15px;}
.card{
    background:#fff;padding:20px;border-radius:15px;box-shadow:0 4px 8px rgba(0,0,0,.05);margin-bottom:15px;text-align:center;
}
.card h3{margin:0;font-size:22px;color:#203a43;}
.card p{margin:5px 0;color:#555;}
.grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(150px,1fr));gap:15px;}
.quick-links{display:grid;grid-template-columns:repeat(auto-fit,minmax(150px,1fr));gap:10px;margin-top:20px;}
.quick-links a{
    background:#203a43;color:#fff;padding:15px;border-radius:10px;text-decoration:none;display:flex;align-items:center;justify-content:center;gap:10px;font-weight:bold;
}
</style>
</head>
<body>

<header>
  
    <img src="../assets/images/logo.png" alt="My VTU App" height="50">
    <h2>Admin Dashboard</h2>
    <nav>
        <span><?php echo $_SESSION['admin_name'] ?? 'Admin'; ?></span>
        <a href="auth.php?logout=1"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </nav>
</header>

<div class="container">

<h3>Statistics</h3>
<div class="grid">
    <div class="card">
        <h3><?php echo $total_users; ?></h3>
        <p>Total Users</p>
    </div>
    <div class="card">
        <h3><?php echo $total_transactions; ?></h3>
        <p>Total Transactions</p>
    </div>
    <div class="card">
        <h3>₦<?php echo number_format($total_wallet,2); ?></h3>
        <p>Total Wallet Funds</p>
    </div>
    <div class="card">
        <h3>₦<?php echo number_format($total_referral_bonus,2); ?></h3>
        <p>Total Referral Bonus</p>
    </div>
</div>

<h3>Quick Actions</h3>
<div class="quick-links">
    <a href="users.php"><i class="fas fa-users"></i> Manage Users</a>
    <a href="transactions.php"><i class="fas fa-exchange-alt"></i> Transactions</a>
    <a href="services.php"><i class="fas fa-cogs"></i> Manage Services</a>
    <a href="settings.php"><i class="fas fa-sliders-h"></i> Settings</a>
</div>

</div>

</body>
</html>