<?php
session_start();
include 'includes/db.php';

// Check if user is already logged in
if (isset($_SESSION['user_id'])) {
    // Redirect to dashboard if logged in
    header("Location: dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MYVTU - Home</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f6f8;
            margin: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        header {
            text-align: center;
            padding: 50px 20px 20px 20px;
        }
        header img {
            width: 150px;
        }
        header h1 {
            margin: 10px 0 0 0;
            color: #203a43;
        }
        main {
            flex: 1;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .btn {
            display: inline-block;
            margin: 10px;
            padding: 15px 30px;
            background-color: #203a43;
            color: #f4f6f8;
            text-decoration: none;
            font-weight: bold;
            border-radius: 8px;
            transition: background 0.3s;
        }
        .btn:hover {
            background-color: #ff6600;
        }
        footer {
            text-align: center;
            padding: 20px;
            background-color: #203a43;
            color: #f4f6f8;
        }
    </style>
</head>
<body>

<header>
    <img src="assets/logo.png" alt="MYVTU Logo">
    <h1>DATAPOINT.COM.NG</h1>
    <h3>we offer you with secure, reliable and affordable data and other VTU subscripion at here!!!</h3>
</header>

<main>
    <a href="signup.php" class="btn">Sign Up</a>
    <a href="login.php" class="btn">Login</a>
</main>

<footer>
    Developed by ABHATECH |
    Contact@08028149012
</footer>

</body>
</html>