<?php
session_start();
require_once "config/db.php";

/* 🔐 Login check */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* 📥 Fetch user transactions */
$stmt = $conn->prepare("SELECT service, description, amount, status, created_at FROM transactions WHERE user_id=? ORDER BY created_at DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Transactions | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;gap:10px;}
.container{padding:15px;}
.card{
    background:#fff;padding:15px;border-radius:15px;box-shadow:0 4px 8px rgba(0,0,0,.05);margin-bottom:15px;
}
h4{margin-top:0;margin-bottom:10px;color:#203a43;}
.trans-list{list-style:none;padding:0;margin:0;}
.trans-list li{
    padding:12px;border-bottom:1px solid #eee;display:flex;justify-content:space-between;align-items:center;
}
.trans-list li:last-child{border-bottom:none;}
.status-success{color:#1e7e34;font-weight:bold;}
.status-failed{color:#b71c1c;font-weight:bold;}
.amount{font-weight:bold;}
.date{font-size:12px;color:#888;}
</style>
</head>

<body>

<header>
    <i class="fas fa-arrow-left" onclick="history.back()"></i>
    <b>Transactions</b>
</header>

<div class="container">

<div class="card">
<h4>Transaction History</h4>

<?php if($result->num_rows > 0): ?>
<ul class="trans-list">
    <?php while($row = $result->fetch_assoc()): ?>
    <li>
        <div>
            <div><b><?php echo htmlspecialchars($row['service']); ?></b> - <?php echo htmlspecialchars($row['description']); ?></div>
            <div class="date"><?php echo date("d M Y, H:i", strtotime($row['created_at'])); ?></div>
        </div>
        <div>
            <div class="amount">₦<?php echo number_format($row['amount'],2); ?></div>
            <div class="<?php echo ($row['status']=='SUCCESS')?'status-success':'status-failed'; ?>">
                <?php echo $row['status']; ?>
            </div>
        </div>
    </li>
    <?php endwhile; ?>
</ul>
<?php else: ?>
<p>No transactions yet.</p>
<?php endif; ?>

</div>

</div>

</body>
</html>