<?php
session_start();
require_once "config/db.php";

/* 🔐 Login check */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* 📥 Fetch user balance */
$stmt = $conn->prepare("SELECT balance FROM users WHERE id=?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$balance = $user['balance'];

$message = "";
$error = false;

/* 📺 TV subscription payment */
if (isset($_POST['pay_tv'])) {

    $provider = $_POST['provider'];
    $smartcard = trim($_POST['smartcard']);
    $plan_id = $_POST['plan'];

    // Fetch plan details
    $plan_stmt = $conn->prepare("SELECT plan_name, price FROM tv_plans WHERE id=? AND provider=?");
    $plan_stmt->bind_param("is", $plan_id, $provider);
    $plan_stmt->execute();
    $plan = $plan_stmt->get_result()->fetch_assoc();

    if (!$plan) {
        $message = "Invalid TV plan selected";
        $error = true;
    } elseif ($balance < $plan['price']) {
        $message = "Insufficient wallet balance";
        $error = true;
    } else {
        // Deduct wallet
        $new_balance = $balance - $plan['price'];
        $upd = $conn->prepare("UPDATE users SET balance=? WHERE id=?");
        $upd->bind_param("di", $new_balance, $user_id);
        $upd->execute();

        // Log transaction
        $service = "TV";
        $desc = $provider . " - " . $plan['plan_name'] . " for Smartcard " . $smartcard;
        $status = "SUCCESS";
        $amount = $plan['price'];

        $log = $conn->prepare(
            "INSERT INTO transactions (user_id, service, description, amount, status) VALUES (?,?,?,?,?)"
        );
        $log->bind_param("issds", $user_id, $service, $desc, $amount, $status);
        $log->execute();

        // 🔌 API call to pay TV subscription can be added here

        $message = "TV subscription payment successful!";
        $balance = $new_balance;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Pay TV Subscription | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;gap:10px;}
.container{padding:15px;}
.card{
    background:#fff;padding:15px;border-radius:15px;box-shadow:0 4px 8px rgba(0,0,0,.05);
}
.balance{
    background:#203a43;color:#fff;padding:15px;border-radius:12px;margin-bottom:15px;
}
label{font-size:13px;color:#555;}
select,input{
    width:100%;padding:12px;margin-top:5px;margin-bottom:15px;border-radius:8px;border:1px solid #ddd;
}
button{
    width:100%;padding:13px;background:#203a43;color:#fff;border:none;border-radius:10px;font-size:15px;
}
.msg{
    padding:10px;margin-bottom:10px;border-radius:8px;background:#e7f6ed;color:#1e7e34;
}
.error{
    background:#fdecea;color:#b71c1c;
}
</style>
</head>

<body>

<header>
    <i class="fas fa-arrow-left" onclick="history.back()"></i>
    <b>TV Subscription</b>
</header>

<div class="container">

<div class="balance">
    Wallet Balance: ₦<?php echo number_format($balance,2); ?>
</div>

<?php if ($message): ?>
<div class="msg <?php echo $error ? 'error' : ''; ?>">
    <?php echo $message; ?>
</div>
<?php endif; ?>

<div class="card">
<form method="POST">

<label>TV Provider</label>
<select name="provider" id="provider" required onchange="loadPlans()">
    <option value="">-- Select Provider --</option>
    <option value="DSTV">DSTV</option>
    <option value="GOTV">GOTV</option>
    <option value="STARTIMES">Startimes</option>
</select>

<label>Smartcard Number</label>
<input type="text" name="smartcard" placeholder="Enter Smartcard Number" required>

<label>Plan</label>
<select name="plan" id="plan" required>
    <option value="">-- Select Plan --</option>
    <?php
    // Load all TV plans
    $plans = $conn->query("SELECT id, provider, plan_name, price FROM tv_plans");
    while($row = $plans->fetch_assoc()):
    ?>
    <option value="<?php echo $row['id']; ?>" data-provider="<?php echo $row['provider']; ?>">
        <?php echo $row['provider']." - ".$row['plan_name']." (₦".number_format($row['price'],0).")"; ?>
    </option>
    <?php endwhile; ?>
</select>

<button type="submit" name="pay_tv">
    <i class="fas fa-tv"></i> Pay Subscription
</button>

</form>
</div>

</div>

<script>
function loadPlans(){
    let provider = document.getElementById("provider").value;
    let planSelect = document.getElementById("plan");
    for (let i = 0; i < planSelect.options.length; i++) {
        let opt = planSelect.options[i];
        if(opt.value === "") continue; // skip placeholder
        opt.style.display = (opt.dataset.provider === provider) ? "block" : "none";
    }
    planSelect.value = "";
}
</script>

</body>
</html>