<?php
session_start();
require_once "config/db.php";

/* 🔐 Login check */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* 📥 Fetch user referral details */
$stmt = $conn->prepare("SELECT referral_code, referral_bonus FROM users WHERE id=?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

$referral_code = $user['referral_code'];
$referral_bonus = number_format($user['referral_bonus'],2);

$message = "";
if(isset($_GET['copied'])) {
    $message = "Referral code copied to clipboard!";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Refer & Earn | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;gap:10px;}
.container{padding:15px;}
.card{
    background:#fff;padding:20px;border-radius:15px;box-shadow:0 4px 8px rgba(0,0,0,.05);margin-bottom:15px;
}
.balance{
    background:#203a43;color:#fff;padding:15px;border-radius:12px;margin-bottom:15px;
    text-align:center;font-size:18px;
}
.referral{
    display:flex;justify-content:space-between;align-items:center;
    background:#e7f6ff;padding:12px;border-radius:10px;margin-bottom:10px;
}
.referral span{font-weight:bold;color:#203a43;}
.referral i{cursor:pointer;color:#203a43;}
.msg{
    padding:10px;margin-bottom:10px;border-radius:8px;background:#e7f6ed;color:#1e7e34;
}
</style>
</head>

<body>

<header>
    <i class="fas fa-arrow-left" onclick="history.back()"></i>
    <b>Refer & Earn</b>
</header>

<div class="container">

<?php if($message): ?>
<div class="msg"><?php echo $message; ?></div>
<?php endif; ?>

<div class="card">
    <div class="balance">Your Referral Bonus: ₦<?php echo $referral_bonus; ?></div>

    <div class="referral">
        <span id="referralCode"><?php echo $referral_code; ?></span>
        <i class="fas fa-copy" onclick="copyCode()"></i>
    </div>

    <p>Share your referral code with friends. Each successful referral adds to your bonus balance!</p>
</div>

<div class="card">
    <h4>How it Works:</h4>
    <ul>
        <li>Share your referral code with friends.</li>
        <li>When they sign up and fund wallet, you earn a bonus.</li>
        <li>Referral bonus is automatically added to your wallet.</li>
    </ul>
</div>

<script>
function copyCode(){
    let code = document.getElementById("referralCode").innerText;
    navigator.clipboard.writeText(code);
    alert("Referral code copied: " + code);
}
</script>

</div>

</body>
</html>