<?php
session_start();
require_once "config/db.php";

/* 🔐 Login check */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* 📥 Fetch user details */
$stmt = $conn->prepare("SELECT fullname, email, phone, account_number, balance FROM users WHERE id=?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

$fullname = htmlspecialchars($user['fullname']);
$email = htmlspecialchars($user['email']);
$phone = htmlspecialchars($user['phone']);
$account_number = htmlspecialchars($user['account_number']);
$balance = number_format($user['balance'],2);

$message = "";
if(isset($_GET['copied'])){
    $message = "Account number copied!";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Profile | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;gap:10px;}
.container{padding:15px;}
.card{
    background:#fff;padding:20px;border-radius:15px;box-shadow:0 4px 8px rgba(0,0,0,.05);margin-bottom:15px;
}
label{font-size:13px;color:#555;margin-top:10px;}
input{width:100%;padding:12px;margin-top:5px;margin-bottom:15px;border-radius:8px;border:1px solid #ddd;background:#f7f7f7;}
.balance{
    background:#203a43;color:#fff;padding:15px;border-radius:12px;margin-bottom:15px;text-align:center;font-size:18px;
}
.referral{display:flex;justify-content:space-between;align-items:center;margin-bottom:15px;}
.referral span{font-weight:bold;color:#203a43;}
.referral i{cursor:pointer;color:#203a43;}
button{
    width:100%;padding:12px;background:#203a43;color:#fff;border:none;border-radius:10px;margin-top:10px;font-size:15px;
}
.msg{padding:10px;margin-bottom:10px;border-radius:8px;background:#e7f6ed;color:#1e7e34;}
</style>
</head>
<body>

<header>
    <i class="fas fa-arrow-left" onclick="history.back()"></i>
    <b>Profile</b>
</header>

<div class="container">

<?php if($message): ?>
<div class="msg"><?php echo $message; ?></div>
<?php endif; ?>

<div class="card">
<div class="balance">Wallet Balance: ₦<?php echo $balance; ?></div>

<label>Full Name</label>
<input type="text" value="<?php echo $fullname; ?>" disabled>

<label>Email</label>
<input type="email" value="<?php echo $email; ?>" disabled>

<label>Phone Number</label>
<input type="tel" value="<?php echo $phone; ?>" disabled>

<label>Account Number</label>
<div class="referral">
    <span id="accNumber"><?php echo $account_number; ?></span>
    <i class="fas fa-copy" onclick="copyAccount()"></i>
</div>

<button onclick="location.href='personalinfo.php'"><i class="fas fa-user"></i> Personal Information</button>
<button onclick="location.href='pinreset.php'"><i class="fas fa-key"></i> Reset PIN</button>
<button onclick="location.href='passwordreset.php'"><i class="fas fa-lock"></i> Reset Password</button>
<button onclick="location.href='logout.php'"><i class="fas fa-sign-out-alt"></i> Logout</button>
</div>

</div>

<script>
function copyAccount(){
    let acc = document.getElementById("accNumber").innerText;
    navigator.clipboard.writeText(acc);
    alert("Account number copied: " + acc);
}
</script>

</body>
</html>