<?php
session_start();
require_once "../config/db.php";

// 🔐 Admin login check
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

// Handle form submission
$message = "";
if(isset($_POST['save_pricing'])){
    $service = trim($_POST['service']);
    $provider = trim($_POST['provider']);
    $price = floatval($_POST['price']);

    // Check if service already exists
    $stmt = $conn->prepare("SELECT id FROM service_pricing WHERE service=? AND provider=? LIMIT 1");
    $stmt->bind_param("ss", $service, $provider);
    $stmt->execute();
    $res = $stmt->get_result();

    if($res->num_rows > 0){
        // Update existing price
        $row = $res->fetch_assoc();
        $update = $conn->prepare("UPDATE service_pricing SET price=? WHERE id=?");
        $update->bind_param("di", $price, $row['id']);
        $update->execute();
        $message = "Service price updated successfully!";
    } else {
        // Insert new service price
        $insert = $conn->prepare("INSERT INTO service_pricing (service, provider, price) VALUES (?,?,?)");
        $insert->bind_param("ssd", $service, $provider, $price);
        $insert->execute();
        $message = "Service price added successfully!";
    }
}

// Fetch all pricing
$pricing = $conn->query("SELECT * FROM service_pricing ORDER BY service ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Service Pricing | Admin | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;justify-content:space-between;}
header h2{margin:0;}
nav a{color:#fff;text-decoration:none;margin-left:15px;}
.container{padding:15px;}
.card{background:#fff;padding:20px;border-radius:15px;box-shadow:0 4px 8px rgba(0,0,0,.05);margin-bottom:15px;}
label{display:block;margin-top:10px;color:#333;font-weight:bold;}
input, select{width:100%;padding:12px;margin-top:5px;border-radius:8px;border:1px solid #ddd;}
button{margin-top:15px;padding:12px;background:#203a43;color:#fff;border:none;border-radius:10px;font-size:15px;}
.msg{padding:10px;margin-bottom:10px;border-radius:8px;background:#e7f6ed;color:#1e7e34;}
table{width:100%;border-collapse:collapse;margin-top:20px;}
th,td{padding:12px;text-align:left;border-bottom:1px solid #eee;}
th{background:#203a43;color:#fff;}
tr:hover{background:#f4f6f8;}
</style>
</head>
<body>

<header>
    <h2>Service Pricing</h2>
    <nav>
        <span><?php echo $_SESSION['admin_name'] ?? 'Admin'; ?></span>
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="auth.php?logout=1"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </nav>
</header>

<div class="container">
<div class="card">
<?php if($message): ?>
<div class="msg"><?php echo $message; ?></div>
<?php endif; ?>

<form method="POST">
    <label>Service</label>
    <select name="service" required>
        <option value="">-- Select Service --</option>
        <option value="AIRTIME">Airtime</option>
        <option value="DATA_BUNDLE">Data Bundle</option>
        <option value="TV">TV Subscription</option>
        <option value="EXAM_PIN">Exam Pin</option>
        <option value="ELECTRIC">Electric Bill</option>
        <option value="RECHARGE_PIN">Recharge Pin</option>
    </select>

    <label>Provider</label>
    <input type="text" name="provider" placeholder="Enter provider name" required>

    <label>Price (₦)</label>
    <input type="number" step="0.01" name="price" placeholder="Enter price" required>

    <button type="submit" name="save_pricing"><i class="fas fa-save"></i> Save Pricing</button>
</form>
</div>

<h3>All Services Pricing</h3>
<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>Service</th>
            <th>Provider</th>
            <th>Price (₦)</th>
        </tr>
    </thead>
    <tbody>
    <?php if($pricing->num_rows > 0): ?>
        <?php while($p = $pricing->fetch_assoc()): ?>
        <tr>
            <td><?php echo $p['id']; ?></td>
            <td><?php echo htmlspecialchars($p['service']); ?></td>
            <td><?php echo htmlspecialchars($p['provider']); ?></td>
            <td><?php echo number_format($p['price'],2); ?></td>
        </tr>
        <?php endwhile; ?>
    <?php else: ?>
        <tr><td colspan="4" style="text-align:center;">No pricing found.</td></tr>
    <?php endif; ?>
    </tbody>
</table>

</div>

</body>
</html>