<?php
session_start();
require_once "config/db.php";

/* 🔐 Login check */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* 📥 Fetch user balance */
$stmt = $conn->prepare("SELECT balance FROM users WHERE id=?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$balance = $user['balance'];

$message = "";
$error = false;

/* 💰 Fund wallet form submission */
if(isset($_POST['fund_wallet'])) {
    $amount = floatval($_POST['amount']);

    if($amount < 100) {
        $message = "Minimum fund amount is ₦100";
        $error = true;
    } else {
        // Here, integrate with payment gateway
        // Simulating successful payment for demo

        $new_balance = $balance + $amount;

        $upd = $conn->prepare("UPDATE users SET balance=? WHERE id=?");
        $upd->bind_param("di", $new_balance, $user_id);
        $upd->execute();

        // Log transaction
        $service = "FUND_WALLET";
        $desc = "Wallet funded via online payment: ₦".number_format($amount,2);
        $status = "SUCCESS";

        $log = $conn->prepare(
            "INSERT INTO transactions (user_id, service, description, amount, status) VALUES (?,?,?,?,?)"
        );
        $log->bind_param("issds", $user_id, $service, $desc, $amount, $status);
        $log->execute();

        $message = "Wallet funded successfully: ₦".number_format($amount,2);
        $balance = $new_balance;
    }
}
require_once "auth.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Fund Wallet | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;gap:10px;}
.container{padding:15px;}
.card{
    background:#fff;padding:20px;border-radius:15px;box-shadow:0 4px 8px rgba(0,0,0,.05);margin-bottom:15px;
}
.balance{
    background:#203a43;color:#fff;padding:15px;border-radius:12px;margin-bottom:15px;text-align:center;font-size:18px;
}
label{font-size:13px;color:#555;}
input{width:100%;padding:12px;margin-top:5px;margin-bottom:15px;border-radius:8px;border:1px solid #ddd;}
button{
    width:100%;padding:13px;background:#203a43;color:#fff;border:none;border-radius:10px;font-size:15px;
}
.msg{padding:10px;margin-bottom:10px;border-radius:8px;background:#e7f6ed;color:#1e7e34;}
.error{background:#fdecea;color:#b71c1c;}
.quick{
    display:grid;grid-template-columns:repeat(4,1fr);gap:10px;margin-bottom:15px;
}
.quick button{
    background:#fff;color:#203a43;border:1px solid #203a43;padding:10px;border-radius:8px;font-size:13px;
}
</style>
</head>

<body>

<header>
    <i class="fas fa-arrow-left" onclick="history.back()"></i>
    <b>Fund Wallet</b>
</header>

<div class="container">

<div class="balance">
    Wallet Balance: ₦<?php echo number_format($balance,2); ?>
</div>

<?php if($message): ?>
<div class="msg <?php echo $error ? 'error' : ''; ?>">
    <?php echo $message; ?>
</div>
<?php endif; ?>

<div class="card">
<form method="POST">

<label>Enter Amount (₦)</label>
<input type="number" name="amount" id="amount" min="100" placeholder="e.g 500" required>

<div class="quick">
    <button type="button" onclick="setAmount(500)">₦500</button>
    <button type="button" onclick="setAmount(1000)">₦1,000</button>
    <button type="button" onclick="setAmount(2000)">₦2,000</button>
    <button type="button" onclick="setAmount(5000)">₦5,000</button>
</div>

<button type="submit" name="fund_wallet">
    <i class="fas fa-wallet"></i> Fund Wallet
</button>

</form>
</div>

</div>

<script>
function setAmount(val){
    document.getElementById("amount").value = val;
}
</script>

</body>
</html>