<?php
session_start();
require_once "config/db.php";

/* 🔐 Login check */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* 📥 Fetch user balance */
$stmt = $conn->prepare("SELECT balance FROM users WHERE id=?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$balance = $user['balance'];

$message = "";
$error = false;

/* 🎫 Exam pin purchase */
if (isset($_POST['buy_pin'])) {

    $exam = $_POST['exam'];
    $quantity = intval($_POST['quantity']);

    // Fetch pin price
    $plan_stmt = $conn->prepare("SELECT price FROM exam_pins WHERE exam=?");
    $plan_stmt->bind_param("s", $exam);
    $plan_stmt->execute();
    $plan = $plan_stmt->get_result()->fetch_assoc();

    if (!$plan) {
        $message = "Invalid exam selected";
        $error = true;
    } else {
        $total = $plan['price'] * $quantity;

        if ($balance < $total) {
            $message = "Insufficient wallet balance";
            $error = true;
        } else {
            // Deduct wallet
            $new_balance = $balance - $total;
            $upd = $conn->prepare("UPDATE users SET balance=? WHERE id=?");
            $upd->bind_param("di", $new_balance, $user_id);
            $upd->execute();

            // Log transaction
            $service = "EXAM_PIN";
            $desc = $quantity . " x " . $exam . " pin(s) purchased";
            $status = "SUCCESS";

            $log = $conn->prepare(
                "INSERT INTO transactions (user_id, service, description, amount, status) VALUES (?,?,?,?,?)"
            );
            $log->bind_param("issds", $user_id, $service, $desc, $total, $status);
            $log->execute();

            // 🔌 API call to generate pin(s) can be added here

            $message = $quantity . " " . $exam . " pin(s) purchased successfully!";
            $balance = $new_balance;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Buy Exam Pin | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;display:flex;align-items:center;gap:10px;}
.container{padding:15px;}
.card{
    background:#fff;padding:15px;border-radius:15px;box-shadow:0 4px 8px rgba(0,0,0,.05);
}
.balance{
    background:#203a43;color:#fff;padding:15px;border-radius:12px;margin-bottom:15px;
}
label{font-size:13px;color:#555;}
select,input{
    width:100%;padding:12px;margin-top:5px;margin-bottom:15px;border-radius:8px;border:1px solid #ddd;
}
button{
    width:100%;padding:13px;background:#203a43;color:#fff;border:none;border-radius:10px;font-size:15px;
}
.msg{
    padding:10px;margin-bottom:10px;border-radius:8px;background:#e7f6ed;color:#1e7e34;
}
.error{
    background:#fdecea;color:#b71c1c;
}
.quick{
    display:grid;
    grid-template-columns:repeat(4,1fr);
    gap:10px;
    margin-bottom:15px;
}
.quick button{
    background:#fff;color:#203a43;border:1px solid #203a43;padding:10px;border-radius:8px;font-size:13px;
}
</style>
</head>

<body>

<header>
    <i class="fas fa-arrow-left" onclick="history.back()"></i>
    <b>Buy Exam Pin</b>
</header>

<div class="container">

<div class="balance">
    Wallet Balance: ₦<?php echo number_format($balance,2); ?>
</div>

<?php if ($message): ?>
<div class="msg <?php echo $error ? 'error' : ''; ?>">
    <?php echo $message; ?>
</div>
<?php endif; ?>

<div class="card">
<form method="POST">

<label>Select Exam</label>
<select name="exam" id="exam" required>
    <option value="">-- Select Exam --</option>
    <?php
    // Load exam types
    $exams = $conn->query("SELECT exam, price FROM exam_pins");
    while($row = $exams->fetch_assoc()):
    ?>
    <option value="<?php echo $row['exam']; ?>">
        <?php echo $row['exam'] . " (₦" . number_format($row['price'],0) . ")"; ?>
    </option>
    <?php endwhile; ?>
</select>

<label>Quantity</label>
<input type="number" name="quantity" id="quantity" min="1" value="1" required>

<div class="quick">
    <button type="button" onclick="setQuantity(1)">1</button>
    <button type="button" onclick="setQuantity(2)">2</button>
    <button type="button" onclick="setQuantity(3)">3</button>
    <button type="button" onclick="setQuantity(5)">5</button>
</div>

<button type="submit" name="buy_pin">
    <i class="fas fa-graduation-cap"></i> Buy Pin
</button>

</form>
</div>

</div>

<script>
function setQuantity(val){
    document.getElementById("quantity").value = val;
}
</script>

</body>
</html>