<?php
session_start();
require_once "config/db.php";

/* 🔐 Login check */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* 📥 Fetch user balance */
$u = $conn->prepare("SELECT balance FROM users WHERE id=?");
$u->bind_param("i", $user_id);
$u->execute();
$user = $u->get_result()->fetch_assoc();
$balance = $user['balance'];

$message = "";

/* 🛒 Handle purchase */
if (isset($_POST['buy_data'])) {

    $network = $_POST['network'];
    $plan_id = $_POST['plan'];
    $phone = trim($_POST['phone']);

    /* Get plan */
    $p = $conn->prepare("SELECT plan_name, price FROM data_plans WHERE id=? AND network=?");
    $p->bind_param("is", $plan_id, $network);
    $p->execute();
    $plan = $p->get_result()->fetch_assoc();

    if (!$plan) {
        $message = "Invalid data plan selected";
    } elseif ($balance < $plan['price']) {
        $message = "Insufficient wallet balance";
    } else {

        /* Deduct wallet */
        $new_balance = $balance - $plan['price'];
        $upd = $conn->prepare("UPDATE users SET balance=? WHERE id=?");
        $upd->bind_param("di", $new_balance, $user_id);
        $upd->execute();

        /* Log transaction */
        $t = $conn->prepare(
            "INSERT INTO transactions 
            (user_id, service, description, amount, status) 
            VALUES (?,?,?,?,?)"
        );
        $desc = $network . " Data - " . $plan['plan_name'] . " to " . $phone;
        $status = "SUCCESS";
        $service = "DATA";
        $amount = $plan['price'];

        $t->bind_param("issds", $user_id, $service, $desc, $amount, $status);
        $t->execute();

        /* 🔌 API call should be here */

        $message = "Data purchase successful!";
        $balance = $new_balance;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Buy Data | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{background:#203a43;color:#fff;padding:15px;}
.container{padding:15px;}
.card{
    background:#fff;
    padding:15px;
    border-radius:15px;
    box-shadow:0 4px 8px rgba(0,0,0,.05);
}
label{font-size:13px;color:#555;}
select,input{
    width:100%;
    padding:12px;
    margin-top:5px;
    margin-bottom:15px;
    border-radius:8px;
    border:1px solid #ddd;
}
button{
    width:100%;
    padding:12px;
    background:#203a43;
    color:#fff;
    border:none;
    border-radius:10px;
    font-size:15px;
}
.balance{
    background:#203a43;
    color:#fff;
    padding:15px;
    border-radius:12px;
    margin-bottom:15px;
}
.msg{
    margin-bottom:10px;
    padding:10px;
    border-radius:8px;
    background:#e7f6ed;
    color:#1e7e34;
}
.error{
    background:#fdecea;
    color:#b71c1c;
}
</style>
</head>

<body>

<header>
    <i class="fas fa-arrow-left" onclick="history.back()"></i>
    Buy Data Bundle
</header>

<div class="container">

<div class="balance">
    Wallet Balance: ₦<?php echo number_format($balance,2); ?>
</div>

<?php if ($message): ?>
<div class="msg <?php echo ($message=="Data purchase successful!") ? "" : "error"; ?>">
    <?php echo $message; ?>
</div>
<?php endif; ?>

<div class="card">
<form method="POST">

<label>Select Network</label>
<select name="network" required>
    <option value="">-- Select --</option>
    <option value="MTN">MTN</option>
    <option value="AIRTEL">Airtel</option>
    <option value="GLO">Glo</option>
    <option value="9MOBILE">9Mobile</option>
</select>

<label>Select Data Plan</label>
<select name="plan" required>
<?php
$plans = $conn->query("SELECT id, plan_name, price FROM data_plans");
while($row = $plans->fetch_assoc()):
?>
<option value="<?php echo $row['id']; ?>">
    <?php echo $row['plan_name']; ?> - ₦<?php echo number_format($row['price'],0); ?>
</option>
<?php endwhile; ?>
</select>

<label>Phone Number</label>
<input type="tel" name="phone" placeholder="080XXXXXXXX" required>

<button type="submit" name="buy_data">
    <i class="fas fa-wifi"></i> Buy Data
</button>

</form>
</div>

</div>

</body>
</html>