<?php
session_start();
require_once "config/db.php";

/* 🔐 Check login */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

/* 📥 Fetch user details */
$user_id = $_SESSION['user_id'];

$query = $conn->prepare("SELECT username, balance, referral_bonus, account_number FROM users WHERE id = ?");
$query->bind_param("i", $user_id);
$query->execute();
$result = $query->get_result();
$user = $result->fetch_assoc();

$username = $user['username'];
$balance = number_format($user['balance'], 2);
$referral_bonus = number_format($user['referral_bonus'], 2);
$account_number = $user['account_number'];
require_once "auth.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Dashboard | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link rel="icon" href="../assets/images/favicon-32x32.ico" sizes="32x32" type="image/x-icon">
<link rel="icon" href="../assets/images/favicon-16x16.ico" sizes="16x16" type="image/x-icon">
<link rel="apple-touch-icon" href="../assets/images/favicon-180x180.png">

<style>
body{
    margin:0;
    font-family: 'Segoe UI', sans-serif;
    background:#f4f6f8;
}
header{
    background:#203a43;
    color:#fff;
    padding:15px;
    display:flex;
    justify-content:space-between;
    align-items:center;
}
.hamburger, .notification{
    font-size:22px;
    cursor:pointer;
}
.container{
    padding:15px;
}
.card{
    background:#fff;
    border-radius:15px;
    padding:15px;
    margin-bottom:15px;
    box-shadow:0 4px 8px rgba(0,0,0,0.05);
}
.balance{
    font-size:24px;
    font-weight:bold;
}
.small{
    font-size:13px;
    color:#777;
}
.btn{
    background:#203a43;
    color:#fff;
    border:none;
    padding:10px 15px;
    border-radius:8px;
    cursor:pointer;
}
.services{
    display:grid;
    grid-template-columns:repeat(3,1fr);
    gap:12px;
}
.service-btn{
    background:#fff;
    padding:15px 10px;
    text-align:center;
    border-radius:12px;
    box-shadow:0 2px 5px rgba(0,0,0,0.05);
    font-size:13px;
}
.service-btn i{
    font-size:20px;
    color:#203a43;
    margin-bottom:5px;
}
footer{
    position:fixed;
    bottom:0;
    left:0;
    right:0;
    background:#fff;
    border-top:1px solid #ddd;
    display:flex;
    justify-content:space-around;
    padding:10px 0;
}
footer a{
    color:#555;
    text-decoration:none;
    font-size:12px;
    text-align:center;
}
footer i{
    display:block;
    font-size:18px;
}
.sidebar{
    position:fixed;
    top:0;
    right:-250px;
    width:250px;
    height:100%;
    background:#fff;
    box-shadow:-2px 0 10px rgba(0,0,0,0.1);
    padding:20px;
    transition:.3s;
}
.sidebar a{
    display:block;
    padding:12px 0;
    color:#333;
    text-decoration:none;
    border-bottom:1px solid #eee;
}
.show{
    right:0;
}
.whatsapp{
    position:fixed;
    bottom:80px;
    right:15px;
    background:#25d366;
    color:#fff;
    width:55px;
    height:55px;
    border-radius:50%;
    display:flex;
    align-items:center;
    justify-content:center;
    font-size:26px;
}
</style>
</head>

<body>

<!-- 🔔 Header -->
<header>
  <img src="../assets/images/logo.png" alt="My VTU App" height="50">
    <i class="fas fa-bell notification"></i>
    <div>Welcome, <b><?php echo htmlspecialchars($username); ?></b></div>
    <i class="fas fa-bars hamburger" onclick="toggleMenu()"></i>
</header>

<div class="container">

<!-- 💰 Balance Card -->
<div class="card">
    <div class="small">Wallet Balance</div>
    <div class="balance" id="walletBalance">₦<?php echo $balance; ?></div>
    <i class="fas fa-eye" onclick="toggleBalance()" style="cursor:pointer;"></i>
    <br><br>
    <button class="btn" onclick="location.href='fundwallet.php'">Fund Wallet</button>
    <p class="small">Referral Bonus: ₦<?php echo $referral_bonus; ?></p>
</div>

<!-- 🏦 Account Details -->
<div class="card">
    <div class="small">Account Number</div>
    <b id="acct"><?php echo $account_number; ?></b>
    <i class="fas fa-copy" onclick="copyAccount()"></i>
</div>

<!-- ⚙ Services -->
<div class="services">
    <div class="service-btn"><i class="fas fa-wifi"></i><br>Data Bundle</div>
    <div class="service-btn"><i class="fas fa-phone"></i><br>Airtime</div>
    <div class="service-btn"><i class="fas fa-tv"></i><br>TV Cable</div>
    <div class="service-btn"><i class="fas fa-exchange"></i><br>Airtime to Cash</div>
    <div class="service-btn"><i class="fas fa-graduation-cap"></i><br>Exam Pin</div>
    <div class="service-btn"><i class="fas fa-bolt"></i><br>Electric Bill</div>
    <div class="service-btn"><i class="fas fa-sim-card"></i><br>Data Card</div>
    <div class="service-btn"><i class="fas fa-credit-card"></i><br>Recharge Pin</div>
    <div class="service-btn"><i class="fas fa-users"></i><br>Refer & Earn</div>
</div>

</div>

<!-- 📌 Footer -->
<footer>
    <a href="dashboard.php"><i class="fas fa-home"></i>Dashboard</a>
    <a href="fundwallet.php"><i class="fas fa-wallet"></i>Fund</a>
    <a href="transactions.php"><i class="fas fa-list"></i>Transactions</a>
    <a href="profile.php"><i class="fas fa-user"></i>Profile</a>
</footer>

<!-- ☰ Sidebar -->
<div class="sidebar" id="sidebar">
    <a href="profile.php">Personal Information</a>
    <a href="pin_reset.php">Pin Reset</a>
    <a href="reset_password.php">Reset Password</a>
    <a href="logout.php" style="color:red;">Logout</a>
</div>

<!-- 💬 WhatsApp -->
<a href="https://chat.whatsapp.com/https://chat.whatsapp.com/BJF0UCAC5LfLUrkPzwOmT8" class="whatsapp">
    <i class="fab fa-whatsapp"></i>
</a>

<script>
let visible = true;
function toggleBalance(){
    let bal = document.getElementById("walletBalance");
    if(visible){
        bal.innerHTML = "₦******";
    }else{
        bal.innerHTML = "₦<?php echo $balance; ?>";
    }
    visible = !visible;
}
function copyAccount(){
    let text = document.getElementById("acct").innerText;
    navigator.clipboard.writeText(text);
    alert("Account number copied");
}
function toggleMenu(){
    document.getElementById("sidebar").classList.toggle("show");
}
</script>

</body>
</html>