<?php
session_start();
require_once "config/db.php";

/* 🔐 Login check */
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

/* 📥 Fetch user balance */
$stmt = $conn->prepare("SELECT balance FROM users WHERE id=?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$balance = $user['balance'];

$message = "";
$error = false;

/* 📞 Airtime purchase */
if (isset($_POST['buy_airtime'])) {

    $network = $_POST['network'];
    $phone   = trim($_POST['phone']);
    $amount  = floatval($_POST['amount']);

    if ($amount < 50) {
        $message = "Minimum airtime purchase is ₦50";
        $error = true;
    } elseif ($balance < $amount) {
        $message = "Insufficient wallet balance";
        $error = true;
    } else {

        /* Deduct wallet */
        $new_balance = $balance - $amount;
        $upd = $conn->prepare("UPDATE users SET balance=? WHERE id=?");
        $upd->bind_param("di", $new_balance, $user_id);
        $upd->execute();

        /* Log transaction */
        $service = "AIRTIME";
        $status = "SUCCESS";
        $desc = $network . " Airtime to " . $phone;

        $log = $conn->prepare(
            "INSERT INTO transactions 
            (user_id, service, description, amount, status) 
            VALUES (?,?,?,?,?)"
        );
        $log->bind_param("issds", $user_id, $service, $desc, $amount, $status);
        $log->execute();

        /* 🔌 VTU API call should be here */

        $message = "Airtime purchase successful!";
        $balance = $new_balance;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Buy Airtime | VTU App</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f8;}
header{
    background:#203a43;
    color:#fff;
    padding:15px;
    display:flex;
    align-items:center;
    gap:10px;
}
.container{padding:15px;}
.card{
    background:#fff;
    padding:15px;
    border-radius:15px;
    box-shadow:0 4px 8px rgba(0,0,0,.05);
}
.balance{
    background:#203a43;
    color:#fff;
    padding:15px;
    border-radius:12px;
    margin-bottom:15px;
}
label{font-size:13px;color:#555;}
select,input{
    width:100%;
    padding:12px;
    margin-top:5px;
    margin-bottom:15px;
    border-radius:8px;
    border:1px solid #ddd;
}
button{
    width:100%;
    padding:13px;
    background:#203a43;
    color:#fff;
    border:none;
    border-radius:10px;
    font-size:15px;
}
.msg{
    padding:10px;
    margin-bottom:10px;
    border-radius:8px;
    background:#e7f6ed;
    color:#1e7e34;
}
.error{
    background:#fdecea;
    color:#b71c1c;
}
.quick{
    display:grid;
    grid-template-columns:repeat(4,1fr);
    gap:10px;
    margin-bottom:15px;
}
.quick button{
    background:#fff;
    color:#203a43;
    border:1px solid #203a43;
    padding:10px;
    border-radius:8px;
    font-size:13px;
}
</style>
</head>

<body>

<header>
    <i class="fas fa-arrow-left" onclick="history.back()"></i>
    <b>Buy Airtime</b>
</header>

<div class="container">

<div class="balance">
    Wallet Balance: ₦<?php echo number_format($balance,2); ?>
</div>

<?php if ($message): ?>
<div class="msg <?php echo $error ? 'error' : ''; ?>">
    <?php echo $message; ?>
</div>
<?php endif; ?>

<div class="card">
<form method="POST">

<label>Network</label>
<select name="network" required>
    <option value="">-- Select Network --</option>
    <option value="MTN">MTN</option>
    <option value="AIRTEL">Airtel</option>
    <option value="GLO">Glo</option>
    <option value="9MOBILE">9Mobile</option>
</select>

<label>Phone Number</label>
<input type="tel" name="phone" placeholder="080XXXXXXXX" required>

<label>Amount (₦)</label>
<input type="number" name="amount" id="amount" min="50" placeholder="e.g 100" required>

<div class="quick">
    <button type="button" onclick="setAmount(100)">₦100</button>
    <button type="button" onclick="setAmount(200)">₦200</button>
    <button type="button" onclick="setAmount(500)">₦500</button>
    <button type="button" onclick="setAmount(1000)">₦1000</button>
</div>

<button type="submit" name="buy_airtime">
    <i class="fas fa-phone"></i> Buy Airtime
</button>

</form>
</div>

</div>

<script>
function setAmount(val){
    document.getElementById("amount").value = val;
}
</script>

</body>
</html>